/*
  tcutthru.cpp
  David Rowe 28/8/02

  Tests cut thru performance of dtmf detctor on V12PCI.  Connect 
  station port 0 to loop port 8 then run.

*/

#include "../src/vpbapi.h"
#include <stdio.h>
#include <stdlib.h>
#include <string>
#include "kbhit.h"

VPB_TONE DialTone     = {450, 425, 400, -10,   -10,  -10, 10000, 0   };

int main(int argc, char *argv[]) {
	int       hs,hl, ret;
	VPB_EVENT e;
	char      s[VPB_MAX_STR];
	int       digits_rx;
	int       digits_tx;
	float     percent;

	hs = vpb_open(1,1); // station plays dial tone and listens for digits
	hl = vpb_open(1,9); // loop plays digits
	vpb_sethook_sync(hl, VPB_OFFHOOK);
	digits_tx = 0;
	digits_rx = 0;

	// start the ball rolling
	vpb_playtone_async(hs, &DialTone);	
	vpb_dial_async(hl, "1234567890#*,");

	do {
		ret = vpb_get_event_async(&e);
		if (ret == VPB_OK) {
			vpb_translate_event(&e, s);
			percent = 100.0*(float)digits_rx/digits_tx;
			printf("%s tx: %d rx: %d %3.2f",s, digits_tx, digits_rx, percent);
			
			if (e.handle == hs) {
				if (e.type == VPB_DIALEND) {
					// tone finished so start again
					vpb_playtone_async(hs, &DialTone);	
				}
				if (e.type == VPB_DTMF) {
					digits_rx++;
				}
			}

			if (e.handle == hl) {
				if (e.type == VPB_DIALEND) {
					// tone finished so start again
					digits_tx += 12;
					vpb_dial_async(hl, "1234567890#*,");
				}
			}
		}
		vpb_sleep(10);

	} while(!kbhit());

	vpb_sethook_sync(hl, VPB_ONHOOK);
	vpb_close(hs);
	vpb_close(hl);

	return 0;
}

